import { View, Text, StyleSheet } from "react-native";
import React from "react";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const EmptyContent = ({ Icon, text }) => {
    return (
        <View style={styles.container}>
            <CustomSVG svgIcon={Icon} width={dpr(63)} height={dpr(63)} />
            <Text style={styles.text}>{text}</Text>
        </View>
    );
};

export default EmptyContent;

const styles = StyleSheet.create({
    container: {
        borderWidth: 1,
        borderRadius: dpr(4),
        height: dpr(200),
        flexDirection: "column",
        alignItems: "center",
        justifyContent: "center",
        borderColor: "#DFDFDF",
    },
    text: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        lineHeight: dpr(18),
        color: "#898989",
        marginTop: dpr(14),
    },
});
